-- Collapse all and resize ONLY top-level parent tracks
local parent_height = 110 -- Hauteur pour les dossiers racines
local child_height = 140   -- Hauteur pour les pistes enfants
local current_depth = 0

reaper.Undo_BeginBlock()

local track_count = reaper.CountTracks(0)

-- ÉTAPE 1 : Définir les hauteurs AVANT de collapser
for i = 0, track_count - 1 do
    local track = reaper.GetTrack(0, i)
    local folder_depth = reaper.GetMediaTrackInfo_Value(track, "I_FOLDERDEPTH")
    
    -- Détection du niveau
    if current_depth == 0 and folder_depth == 1 then
        -- Dossier racine
        reaper.SetMediaTrackInfo_Value(track, "I_HEIGHTOVERRIDE", parent_height)
        reaper.SetMediaTrackInfo_Value(track, "B_HEIGHTLOCK", 1)
    else
        -- Pistes enfants ou normales
        reaper.SetMediaTrackInfo_Value(track, "I_HEIGHTOVERRIDE", child_height)
        reaper.SetMediaTrackInfo_Value(track, "B_HEIGHTLOCK", 0)
    end
    
    current_depth = current_depth + folder_depth
end

-- ÉTAPE 2 : Maintenant on collapse tout
current_depth = 0
for i = 0, track_count - 1 do
    local track = reaper.GetTrack(0, i)
    local folder_depth = reaper.GetMediaTrackInfo_Value(track, "I_FOLDERDEPTH")
    
    reaper.SetMediaTrackInfo_Value(track, "I_FOLDERCOMPACT", 2)
    
    current_depth = current_depth + folder_depth
end

reaper.Undo_EndBlock("Collapse and resize root parents only", -1)
reaper.TrackList_AdjustWindows(true)
reaper.UpdateArrange()
